<?php
/*
 * Plugin Name: Columns
 * Plugin URI: http://wptation.com
 * Description:
 * Version: 1.0
 * Author: Orkun Gürsel
 * Author URI: http://wptation.com
 * Shortcode:
 * Attributes:
 */
cloudfw_register_shortcode( 'CloudFw_Shortcode_Columns', 'columns', 'columns', 5 );
if ( ! class_exists('CloudFw_Shortcode_Columns') ) {
	class CloudFw_Shortcode_Columns extends CloudFw_Shortcodes {

		function get_called_class(){ return get_class($this); }

		/** Register */
		function register() {
			return array(
				'1of1',
				'1of2',
				'1of3',
				'1of4',
				'1of5',
				'1of6',

				'2of3',
				'3of4',
				'2of5',
				'3of5',
				'4of5',
				'5of6',

				'1of1_last',
				'1of2_last',
				'1of3_last',
				'1of4_last',
				'1of5_last',
				'1of6_last',

				'2of3_last',
				'3of4_last',
				'2of5_last',
				'3of5_last',
				'4of5_last',
				'5of6_last',

			);

		}

		/** Run */
		function shortcode( $atts = array(), $content =  NULL, $case = NULL ) {
			return cloudfw_UI_column( $atts, $content, $case );
		}

		/** Admin Scheme */
		function scheme() {
			return 	array(
				'title'		=>	__('Single Columns','envision-core'),
				'script'	=> array(
					'shortcode:sync' => 'column_number',
					'tag_close'  => true,
					'attributes' =>	array(
						'content' 	=> array( 'e' => 'columns_content' ),
					)
				),
				'data'		=>	array(

					5 => array(
						'type'		=> 'module',
						'title'		=> __('Column','envision-core'),
						'data'		=> array(

							## Element
							array(
								'type'		=>	'select',
								'id'		=>	'column_number',
								'value'		=>	'',
								'ui'		=>	true,
								'source'	=>	array(
									'1of2'      => '1/2',
									'1of2_last' => '1/2 last',
									'1of3'      => '1/3',
									'1of3_last' => '1/3 last' ,
									'1of4'      => '1/4',
									'1of4_last' => '1/4 last',
									'1of5'      => '1/5',
									'1of5_last' => '1/5 last',
									'1of6'      => '1/6',
									'1of6_last' => '1/6 last',

									'2of3'		=> '2/3',
									'2of3_last'	=> '2/3 last',
									'3of4'		=> '3/4',
									'3of4_last'	=> '3/4 last',
									'2of5'		=> '2/5',
									'2of5_last'	=> '2/5 last',
									'3of5'		=> '3/5',
									'3of5_last'	=> '3/5 last',
									'4of5'		=> '4/5',
									'4of5_last'	=> '4/5 last',
									'5of6'		=> '5/6',
									'5of6_last'	=> '5/6 last',
								),
								'width'		=> 250,
							), // #### element: 0

						),

					),  // #### element: 5

					10 => array(
						'type'		=> 'module',
						'title'		=> __('Content','envision-core'),
						'data'		=> array(

							## Element
							array(
								'type'		=>	'textarea',
								'id'		=>	'columns_content',
								'value'		=>	'',
							), // #### element: 0

						)

					),  // #### element: 10

				)

			);

		}

	}

}