<?php
/*
* 2007-2012 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2012 PrestaShop SA

*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_CAN_LOAD_FILES_'))
	exit;
	
class blockleosocial extends Module
{
	public function __construct()
	{
		$this->name = 'blockleosocial';
		$this->version = '1.0';
		$this->author = 'leotheme';
		parent::__construct();

		$this->displayName = $this->l('Block leo social');
		$this->description = $this->l('Allows you to add extra information about social networks');
	}
	
	public function install()
	{
		return (parent::install() AND Configuration::updateValue('blockleosocial_facebook', '#') AND Configuration::updateValue('blockleosocial_linkin', '#') && Configuration::updateValue('blockleosocial_twitter', '#') && Configuration::updateValue('blockleosocial_gg', '#') && Configuration::updateValue('blockleosocial_rss', '#') && $this->registerHook('displayHeader'));
		
	}
	
	public function uninstall()
	{
		//Delete configuration			
		return (Configuration::deleteByName('blockleosocial_facebook') AND Configuration::deleteByName('blockleosocial_linkin') AND Configuration::deleteByName('blockleosocial_facebook') AND Configuration::deleteByName('blockleosocial_twitter') AND Configuration::deleteByName('blockleosocial_gg') AND Configuration::deleteByName('blockleosocial_rss') AND parent::uninstall());
	}
	
	public function getContent()
	{
		// If we try to update the settings
		$output = '';
		if (isset($_POST['submitModule']))
		{	
			Configuration::updateValue('blockleosocial_facebook', (($_POST['facebook_url'] != '') ? $_POST['facebook_url']: ''));
			Configuration::updateValue('blockleosocial_linkin', (($_POST['linkin_url'] != '') ? $_POST['linkin_url']: ''));
			Configuration::updateValue('blockleosocial_twitter', (($_POST['twitter_url'] != '') ? $_POST['twitter_url']: ''));		
			Configuration::updateValue('blockleosocial_gg', (($_POST['gg_url'] != '') ? $_POST['gg_url']: ''));		
			Configuration::updateValue('blockleosocial_rss', (($_POST['rss_url'] != '') ? $_POST['rss_url']: ''));				
			$output = '<div class="conf confirm">'.$this->l('Configuration updated').'</div>';
		}
		
		return '
		<h2>'.$this->displayName.'</h2>
		'.$output.'
		<form action="'.Tools::htmlentitiesutf8($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset class="width2">				
				<label for="facebook_url">'.$this->l('Facebook URL: ').'</label>
				<input type="text" id="facebook_url" name="facebook_url" value="'.Tools::safeOutput((Configuration::get('blockleosocial_facebook') != "") ? Configuration::get('blockleosocial_facebook') : "").'" />
				<div class="clear">&nbsp;</div>	
				<label for="linkin_url">'.$this->l('LinkedIn URL: ').'</label>
				<input type="text" id="linkin_url" name="linkin_url" value="'.Tools::safeOutput((Configuration::get('blockleosocial_linkin') != "") ? Configuration::get('blockleosocial_linkin') : "").'" />
				<div class="clear">&nbsp;</div>		
				<label for="twitter_url">'.$this->l('Twitter URL: ').'</label>
				<input type="text" id="twitter_url" name="twitter_url" value="'.Tools::safeOutput((Configuration::get('blockleosocial_twitter') != "") ? Configuration::get('blockleosocial_twitter') : "").'" />
				<div class="clear">&nbsp;</div>		
				<label for="gg_url">'.$this->l('Google +: ').'</label>
				<input type="text" id="gg_url" name="gg_url" value="'.Tools::safeOutput((Configuration::get('blockleosocial_gg') != "") ? Configuration::get('blockleosocial_gg') : "").'" />
				<div class="clear">&nbsp;</div>
				<label for="rss_url">'.$this->l('RSS URL: ').'</label>
				<input type="text" id="rss_url" name="rss_url" value="'.Tools::safeOutput((Configuration::get('blockleosocial_rss') != "") ? Configuration::get('blockleosocial_rss') : "").'" />
				<div class="clear">&nbsp;</div>						
				<br /><center><input type="submit" name="submitModule" value="'.$this->l('Update settings').'" class="button" /></center>
			</fieldset>
		</form>';
	}
	
	public function hookDisplayHeader()
	{
		$this->context->controller->addCSS(($this->_path).'blockleosocial.css', 'all');
	}
		
	function processHook($pparams, $pos="bottom")
	{
		global $smarty;

		$smarty->assign(array(
			'facebook_url' => Configuration::get('blockleosocial_facebook'),
			'linkin_url' => Configuration::get('blockleosocial_linkin'),
			'twitter_url' => Configuration::get('blockleosocial_twitter'),
			'gg_url' => Configuration::get('blockleosocial_gg'),
			'rss_url' => Configuration::get('blockleosocial_rss')			
		));
		return $this->display(__FILE__, 'blockleosocial.tpl');
	}
	
		/*
	 * register hook left comlumn to display slide in left column
	 */
	function hookleftColumn($params){		
		return $this->processHook( $params,"leftColumn");
	}
	
	function hooktop($params){		
		return $this->processHook( $params,"top");
	}
	
	function hookDisplaySlideshow($params){ 		
		return $this->processHook( $params,"slideshow");
	}
	function hookDisplayPromoteTop($params){ 		
		return $this->processHook( $params,"ptop");
	}
	function hookDisplayBottom($params){ 		
		return $this->processHook( $params,"bottom");
	}
	function hookDisplayContentBottom($params){ 		
		return $this->processHook( $params,"cbottom");
	}
	function hookDisplayFootNav($params){ 		
		return $this->processHook( $params,"footnav");
	} 		
	function hookHome($params){
		return $this->processHook( $params,"home");
	}
	function hookFooter($params){
		return $this->processHook( $params,"footer");
	}
}
?>
