<?php
/**
 * Single Product Up-Sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/up-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( $upsells ) : 


global $woocommerce_loop;

$columns = cloudfw_get_option( 'woocommerce', 'up_sells_column' );
if ( empty($columns) ) {
	$columns = 3; 
}

$woocommerce_loop['columns'] 	= $columns;
$woocommerce_loop['image_ratio'] = cloudfw_get_option( 'woocommerce', 'related_media_ratio' );
$woocommerce_loop['shadow'] = cloudfw_get_option( 'woocommerce', 'related_shadow' );
$woocommerce_loop['effect'] = cloudfw_get_option( 'woocommerce', 'related_effect' );
$woocommerce_loop['show_hover'] = cloudfw_check_onoff( 'woocommerce', 'related_hover' );
$woocommerce_loop['hover_effect'] = cloudfw_get_option( 'woocommerce', 'related_hover_effect' );


global $woocommerce_loop_layout;
	   $woocommerce_loop_layout = cloudfw_get_option('woocommerce', 'up_sells_layout');

?>

	<section class="up-sells upsells products">

		<?php echo do_shortcode(cloudfw_transfer_shortcode_attributes( 'title', array( 'element' => 'h3' ), '<strong>'. __('You may also like&hellip;','envision') .'</strong>' )); ?>

		<?php woocommerce_product_loop_start(); ?>

			<?php foreach ( $upsells as $upsell ) : ?>

				<?php
				 	$post_object = get_post( $upsell->get_id() );

					setup_postdata( $GLOBALS['post'] =& $post_object );

					wc_get_template_part( 'content', 'product' ); ?>

			<?php endforeach; ?>

		<?php woocommerce_product_loop_end(); ?>

	</section>

<?php endif;

wp_reset_postdata();