<?php

$scheme[ cloudfw_id_for_sequence( $scheme, $number ) ] = array(
	'type'			=>	'section',
	'title'			=>	__('Header','envision'),
	'data'			=>	array(

		array(
			'type'		=>	'module-set',
			'title'		=>	__('Header','envision'),
			'closable'	=>	true,
			'state'		=>	'opened',
			'data'		=>	array(

				## Module Item
				array(
					'type'      =>  'module',
					'title'     =>  __('Header Overlapping?','envision'),
					'data'      =>  array(
						array(
							'type'      => 'select',
							'id'		=>	cloudfw_sanitize('options','header_overlapping'),
							'value'		=>	$data['options']['header_overlapping'],
							'width'		=>	250,
							'source'	=>	array(
								'NULL'		=>	__('Use Global Setting','envision'),
								'true'		=>	__('Yes','envision'),
								'FALSE'		=>	__('No','envision'),
							),
						)
					)
				),

				array(
					'type'      =>  'module-set',
					'title'     =>  __('Header Background','envision'),
					'closable'  =>  false,
					'state'     =>  'opened',
					'layout'    =>  'subtab',
					'data'      =>  array(

						## SubTab Item
						array(
							'type'      =>  'tabs',
							'tab_id'    =>  'tab:header-global',
							'tab_title' =>  __('Global','envision'),
							'icon'      =>  'widescreen',
							'data'      =>  array(

								## Module Item
								array(
									'type'		=>	'module',
									'ucode'		=>	'HEADER BACKGROUND',
									'title'		=>	__('Background','envision'),
									'data'		=>	array(

										array(
											'type'		=>	'grid',
											'data'		=>	array(
												array(
													'type'		=>	'gradient',
													'title'		=>	__('Header Background','envision'),
													'id'		=>	cloudfw_sanitize('header','gradient'),
													'value'		=>	$data['header']['gradient'],
												),
												array(
													'type'		=>	'bg-set',
													'id'		=>	'header',
													'id:pattern'=>	'header',
													'value'		=>	$data,
													'attachment'=>	false
												)
											)
										),
									)
								),
							)
						),

						## SubTab Item
						array(
							'type'      =>  'tabs',
							'tab_id'    =>  'tab:header-tablet',
							'tab_title' =>  __('Tablet','envision'),
							'icon'      =>  'tablet',
							'data'      =>  array(

								## Module Item
								array(
									'type'		=>	'module',
									'ucode'		=>	'HEADER BACKGROUND',
									'title'		=>	__('Background','envision'),
									'data'		=>	array(

										array(
											'type'		=>	'grid',
											'data'		=>	array(
												array(
													'type'		=>	'gradient',
													'title'		=>	__('Header Background','envision'),
													'id'		=>	cloudfw_sanitize('header_tablet','gradient'),
													'value'		=>	$data['header_tablet']['gradient'],
												),
												array(
													'type'		=>	'bg-set',
													'id'		=>	'header_tablet',
													'id:pattern'=>	'header_tablet',
													'value'		=>	$data,
													'attachment'=>	false
												)
											)
										),
									)
								),
							)
						),

						## SubTab Item
						array(
							'type'      =>  'tabs',
							'tab_id'    =>  'tab:header-phone',
							'tab_title' =>  __('Mobile','envision'),
							'icon'      =>  'phone',
							'data'      =>  array(

								## Module Item
								array(
									'type'		=>	'module',
									'ucode'		=>	'HEADER BACKGROUND',
									'title'		=>	__('Background','envision'),
									'data'		=>	array(

										array(
											'type'		=>	'grid',
											'data'		=>	array(
												array(
													'type'		=>	'gradient',
													'title'		=>	__('Header Background','envision'),
													'id'		=>	cloudfw_sanitize('header_mobile','gradient'),
													'value'		=>	$data['header_mobile']['gradient'],
												),
												array(
													'type'		=>	'bg-set',
													'id'		=>	'header_mobile',
													'id:pattern'=>	'header_mobile',
													'value'		=>	$data,
													'attachment'=>	false
												)
											)
										),
									)
								),
							)
						),
					)
				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'HEADER BORDER',
					'title'		=>	__('Border Bottom','envision'),
					'data'		=>	array(

						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'id'		=>	cloudfw_sanitize('header','+border-bottom'),
							'value'		=>	$data['header']['+border-bottom'],
						),


					)


				),

				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'CONTENT',
					'title'		=>	__('Text Color','envision'),
					'layout'	=>	'float',
					'data'		=>	array(
						## Element
						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	__('Color','envision'),
							'id'		=>	cloudfw_sanitize('header_text','color'),
							'value'		=>	$data['header_text']['color'],

						),

					)

				),


				## Module Item
				array(
					'type'		=>	'module',
					'ucode'		=>	'CONTENT LINK',
					'title'		=>	__('Link Colors','envision'),
					'layout'	=>	'float',
					'data'		=>	array(
						## Element
						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	__('Color','envision'),
							'id'		=>	cloudfw_sanitize('header_link','color'),
							'value'		=>	$data['header_link']['color'],

						),

						## Element
						array(
							'type'		=>	'color',
							'style'		=>	'horizontal',
							'title'		=>	__('Hover Color','envision'),
							'id'		=>	cloudfw_sanitize('header_link_hover','color'),
							'value'		=>	$data['header_link_hover']['color'],

						),

						array(
							'type'		=>	'select',
							'ui'		=>	true,
							'width'		=>	120,
							'title'		=>	__('Text-Decoration','envision'),
							'id'		=>	cloudfw_sanitize('header_link','text-decoration'),
							'value'		=>	$data['header_link']['text-decoration'],
							'source'	=>	$array_text_decorations,

						),
						array(

							'type'		=>	'select',
							'ui'		=>	true,
							'width'		=>	120,
							'title'		=>	__('Text-Decoration Hover','envision'),
							'id'		=>	cloudfw_sanitize('header_link_hover','text-decoration'),
							'value'		=>	$data['header_link_hover']['text-decoration'],
							'source'	=>	$array_text_decorations,

						)

					)

				),

			)

		),

	)

);