<?php

function cloudfw_make_button_style( $color, $to_class = false, $extra_class = '' ) {

	$button_classes = array();

	if ( !is_array( $extra_class ) ) {
		$extra_class = array( $extra_class );
	}

	$button_classes = array_merge( $button_classes, $extra_class );

	/** Set Class for Color */
	if ( !empty($color) ) {
		$cloudfw_pre_colors = cloudfw_button_array();

		if ( !isset($cloudfw_pre_colors[ $color ]) ) {
			$button_classes[] = $color;
			$button_classes[] = 'btn-custom-color';
			$is_custom_color = true;
		} else {
			$button_classes[] = $color;
			$is_custom_color = false;
		}
	}


	if ( $is_custom_color ) {

		$custom_colors = cloudfw_walk_options( array(
			'id'                     => 'indicator',
			'name'                   => 'name',
			'name'                   => 'name',
			'gradient_start'         => 'gradient_0',
			'gradient_stop'          => 'gradient_1',
			'gradient_start_hover'   => 'gradient_hover_0',
			'gradient_stop_hover'    => 'gradient_hover_1',
			'color'                  => 'color',
			'color_hover'            => 'color_hover',
			'border_color'           => 'border_color',
			'border_color_hover'     => 'border_color_hover',
			'shadow_color'           => 'shadow_color',
			'shadow_color_hover'     => 'shadow_color_hover',
			'shadow_direction'       => 'shadow_direction',
			'shadow_direction_hover' => 'shadow_direction_hover',
		), cloudfw_get_option('button_colors'), 'indicator' );

		$current_custom_color = isset($custom_colors[ $color ]) ? $custom_colors[ $color ] : NULL;
		unset($custom_colors);

		if ( isset($current_custom_color) && $current_custom_color ) {

			if ( !cloudfw_vc_isset( 'css', 'button-' . $current_custom_color['id'] ) ) {
				$custom_color_css  = '';

				if ( empty($current_custom_color['gradient_start']) ) {
					$current_custom_color['gradient_start'] = $current_custom_color['gradient_stop'];
				} elseif ( empty($current_custom_color['gradient_stop']) ) {
					$current_custom_color['gradient_stop'] = $current_custom_color['gradient_start'];
				}

				if ( !empty($current_custom_color['border_color']) ) {
					cloudfw_vc_set( 'css_button_border', $current_custom_color['id'], true );
				}

				$custom_class = 'html .' . (isset($current_custom_color['id']) ? $current_custom_color['id'] : NULL);

				/** Link */
				$custom_color_css .= $custom_class . ' {';
				$custom_color_css .= cloudfw_make_style_attribute( array(
					'!color'         => $current_custom_color['color'],
					'gradient'       => array($current_custom_color['gradient_start'], $current_custom_color['gradient_stop']),
					'!text-shadow'   => !empty($current_custom_color['shadow_color']) ? '0 '. _if( !empty($current_custom_color['shadow_direction']), $current_custom_color['shadow_direction'], '-1' ) . 'px 0 #' . $current_custom_color['shadow_color'] : NULL,
					'!+border'       => $current_custom_color['border_color'],
				), FALSE, FALSE );
				$custom_color_css .= '}';


				if ( empty($current_custom_color['gradient_start_hover']) ) {
					$current_custom_color['gradient_start_hover'] = isset($current_custom_color['gradient_stop_hover']) ? $current_custom_color['gradient_stop_hover'] : $current_custom_color['gradient_stop'];
				}

				if ( empty($current_custom_color['gradient_stop_hover']) ) {
					$current_custom_color['gradient_stop_hover'] = isset($current_custom_color['gradient_start_hover']) ? $current_custom_color['gradient_start_hover'] : $current_custom_color['gradient_start'];
				}

				/** Hover */
				$custom_color_css .= $custom_class . ':hover,';
				$custom_color_css .= $custom_class . ':focus,';
				$custom_color_css .= $custom_class . ':active,';
				$custom_color_css .= $custom_class . ':disabled,';
				$custom_color_css .= $custom_class . '[disabled] {';
				$custom_color_css .= cloudfw_make_style_attribute( array(
					'!color'         => !empty($current_custom_color['color_hover']) ? $current_custom_color['color_hover'] : $current_custom_color['color'],
					'!gradient'       => array($current_custom_color['gradient_start_hover'], $current_custom_color['gradient_stop_hover']),
					'!text-shadow'   => !empty($current_custom_color['shadow_color_hover']) ? '0 '. _if( !empty($current_custom_color['shadow_direction_hover']), $current_custom_color['shadow_direction_hover'], '-1' ) . 'px 0 #' . $current_custom_color['shadow_color_hover'] : NULL,
					'!+border'       => $current_custom_color['border_color_hover'],
				), FALSE, FALSE );
				$custom_color_css .= '}';

				cloudfw_vc_set( 'css', 'button-' . $current_custom_color['id'], $custom_color_css );
				unset( $custom_color_css );

			}

		}

	}

	if ( !empty( $button_classes ) ) {
		$button_classes = array_filter( $button_classes );
		$button_classes = implode( ' ', $button_classes );
	}

	if ( $to_class ) {
		return $button_classes;
	} else {
		return compact( 'color', 'is_custom_color', 'button_classes' );
	}

}


if ( ! function_exists('cloudfw_create_button') ) {
	function cloudfw_create_button( $atts = array(), $text ){
		static $cloudfw_button_crator;

		if ( !class_exists('CloudFw_Shortcode_Buttons') ) {
			return;
		}

		if ( !isset( $cloudfw_button_crator ) ) {
			$cloudfw_button_crator = new CloudFw_Shortcode_Buttons();
		}

		if ( ! isset( $atts['echo'] ) || $atts['echo'] == true ) {
			echo cloudfw_escape($cloudfw_button_crator->shortcode( $atts, $text ));
		} else {
			return $cloudfw_button_crator->shortcode( $atts, $text );
		}
	}
}


/**
 *  CloudFw Predefined Buttons
 *
 *  @hook: cloudfw_buttons
 *  @since 1.0
 */
function cloudfw_button_array() {

	$cloudfw_button_colors = array();
	$cloudfw_button_colors["btn-primary"]       = __('Primary Color','envision');
	$cloudfw_button_colors["btn-secondary"]     = __('Secondary Color','envision');
	$cloudfw_button_colors["btn-secondary muted"] = __('Muted Secondary Color','envision');
	$cloudfw_button_colors["btn-blue"]          = __('Blue','envision');
	$cloudfw_button_colors["btn-grey"]          = __('Grey','envision');
	$cloudfw_button_colors["btn-dark-grey"]     = __('Dark Grey','envision');
	$cloudfw_button_colors["btn-light-green"]   = __('Light Green','envision');
	$cloudfw_button_colors["btn-green"]         = __('Green','envision');
	$cloudfw_button_colors["btn-aqua"]          = __('Aqua','envision');
	$cloudfw_button_colors["btn-red"]           = __('Red','envision');
	$cloudfw_button_colors["btn-dark-red"]      = __('Dark Red','envision');
	$cloudfw_button_colors["btn-yellow"]        = __('Yellow','envision');
	$cloudfw_button_colors["btn-orange"]        = __('Orange','envision');
	$cloudfw_button_colors["btn-dark"]          = __('Dark','envision');
	$cloudfw_button_colors["btn-black"]         = __('Black','envision');


	return apply_filters('cloudfw_buttons', $cloudfw_button_colors);
}

/**
 *  Prepare Button Colors Array
 *
 *  @since 1.0
 */
function cloudfw_admin_loop_button_colors( $default_text = '' ){
	$out = array();
	if ( !empty( $default_text ) ) {
		$out['NULL'] = $default_text;
	}

	if ( cloudfw_vc_isset( __FUNCTION__, 'cache' ) ) {
		$out = cloudfw_vc_get( __FUNCTION__, 'cache' );
	} else {

		$cloudfw_button_colors = cloudfw_button_array();

		$colors = cloudfw_walk_options( array(
			'id'                => 'indicator',
			'name'              => 'name',
		), cloudfw_get_option('button_colors'), 'indicator' );

		$cloudfw_custom_colors = array();
		$custom_colors = array();
		if ( !empty($colors) && is_array($colors) ) {
			foreach ($colors as $id => $color) {
				if ( empty($color["name"]) )
					continue;

				$cloudfw_custom_colors[ $id ] = $color["name"];
			}
		}

		if ( !empty($cloudfw_button_colors) ) {
			$out[ __('Predefined Colors','envision') ] = $cloudfw_button_colors;
		}

		if ( !empty($cloudfw_custom_colors) ) {
			$out[ __('Custom Colors','envision') ] = $cloudfw_custom_colors;
		}

		cloudfw_vc_set( __FUNCTION__, 'cache', $out );

	}

	return $out;

}