<?php
/**
 *	Check PHP version is compatible with the theme or not
 *
 *	@since 1.0
 */
if ( version_compare(PHP_VERSION, CLOUDFW_MINPHPVERSION, '<') ) {
	$error_message = '<strong>'.__('Warning','envision').':</strong>';
	$error_message.= '<br/>';
	$error_message.= sprintf( __('Sorry, this template will only run on PHP version %1$s or greater! Current version: %2$s','envision'), CLOUDFW_MINPHPVERSION, PHP_VERSION );

	if ( defined('WP_DEFAULT_THEME') )
		switch_theme( WP_DEFAULT_THEME, WP_DEFAULT_THEME );

	wp_die( $error_message, __('CloudFw Error','envision') );
	exit;
}

/**
 *	Check WP version is compatible with the theme or not
 *
 *	@since 1.0
 */
if ( version_compare( CLOUDFW_WPVERSION , CLOUDFW_MINWPVERSION, '<') ) {
	$error_message = '<strong>'.__('Warning','envision').':</strong>';
	$error_message.= '<br/>';
	$error_message.= sprintf( __('Sorry, this template will only run on WordPress %1$s or greater! (Current version: %2$s)','envision'), CLOUDFW_MINWPVERSION, get_bloginfo('version') );

	if ( defined('WP_DEFAULT_THEME') )
		switch_theme( WP_DEFAULT_THEME, WP_DEFAULT_THEME );

	wp_die( $error_message, __('CloudFw Error','envision') );
	exit;
}

/**
 *	Check is the theme in the correct folder
 *
 *	@since 2.3
 */

if ( basename( dirname( CLOUDFW_TMP_PATH ) ) !== 'themes' ) {
	$theme_folder  = basename( CLOUDFW_TMP_PATH );
	$true_folder   = str_replace( '/', '\\', ABSPATH . basename(content_url('themes')) ) .'\\';
	$wrong_folder  = dirname( CLOUDFW_TMP_PATH ).'\\';

	$error_message = '<strong>'.__('Warning','envision').':</strong>';
	$error_message.= '<br/>';
	$error_message.= __('It seems that you uploaded all folders in the theme package that downloaded by you from ThemeForest, to the themes folder of WordPress.','envision');
	$error_message.= '<br/><br/>';
	$error_message.= sprintf( __('The theme folder (%3$s/) in the theme package has to be in <em>%1$s</em> folder, not in <em>%2$s</em> folder.' ,'envision'),
		$true_folder,
		$wrong_folder,
		$theme_folder
	);
	$error_message.= '<br/><br/>';
	$error_message.= '<strong>'.__('Solution','envision').':</strong>';
	$error_message.= '<br/>';
	$error_message.= sprintf( __('You should move or copy the "%3$s/" folder into <em>%1$s</em> folder. Then delete <em>%2$s</em> folder and re-activate the theme.' ,'envision'),
		$true_folder,
		$wrong_folder,
		$theme_folder
	);

	if ( defined('WP_DEFAULT_THEME') )
		switch_theme( WP_DEFAULT_THEME, WP_DEFAULT_THEME );

	wp_die( $error_message, __('CloudFw Error','envision') );
}

/**
 *	Check Upload Folders
 *
 *	@since 1.0
 */
function cloudfw_check_upload_folders(){
	/*if ( ! cloudfw_is_writable( CLOUDFW_UPLOADDIR ) === true ) {
		add_action( 'network_admin_notices', 'cloudfw_check_upload_folder_message', 4 );
		add_action( 'admin_notices', 'cloudfw_check_upload_folder_message', 1 );
	}*/

	if ( ! cloudfw_is_writable( CACHE_DIR_BASE ) === true  ) {
		add_action( 'network_admin_notices', 'cloudfw_check_cache_folder_message', 4 );
		add_action( 'admin_notices', 'cloudfw_check_cache_folder_message', 1 );
	}

	if ( ! cloudfw_is_core_plugin_installed() && current_user_can('install_plugins') ) {
		add_action( 'network_admin_notices', 'cloudfw_needs_core_plugin_message', 4 );
		add_action( 'admin_notices', 'cloudfw_needs_core_plugin_message', 1 );
	}

}

function cloudfw_needs_core_plugin_message() {
	$hide = get_user_option( PFIX . '_dismiss_core_plugin_error', get_current_user_id() );

	if ( isset( $_GET['cloudfw-dismiss-core-plugin-error'] ) ) {
		$hide = true;
		update_user_option( get_current_user_id(), PFIX . '_dismiss_core_plugin_error', true, true );
	}

	if ( isset( $_GET['page'] ) && 'tgmpa-install-plugins' === $_GET['page'] ) {
		$hide = true;
	}

	if ( $hide ) {
		return;
	}

	$install_plugins_url = "";
    if ( isset( $GLOBALS['tgmpa'] ) ) {
        $install_plugins_url = $GLOBALS['tgmpa']->get_tgmpa_url();
	}

	printf ("<div class='cloudfw-update-messages notice-error settings-error notice' style='position: relative; padding-right: 30px;'>%s</div>",
		sprintf ("<p>%s</p>%s",
			wp_kses(
				sprintf(
					__( 'The theme needs to be installed <strong>Envision Core Plugin</strong> to have all functionalities. Please install and activate the plugin on %s page.', 'envision' ),
					'<a href="'. esc_url( $install_plugins_url ) .'">'. __('<strong>Apperance &rarr; Install Plugins</strong>', 'envision') .'</a>'
				),
				array(
					'br' => true,
					'strong' => true,
					'a' => array(
						'href' => true
					)
				)
			),
			'<a style="text-decoration: none;" href="'. esc_url( add_query_arg( NULL, array( 'cloudfw-dismiss-core-plugin-error' => true ) ) ) .'" class="notice-dismiss"><span class="screen-reader-text">'. esc_html__('Dismiss this notice.', 'envision') .'</span></a>'
		)
	);
}

function cloudfw_check_upload_folder_message() {
	  printf ("<div class='cloudfw-update-messages error'>%s</div>",
	  sprintf ("<div style='padding:15px;'>%s</div>",
		sprintf ( __('Error: %s folder is not writable. Please adjust the chmod permissions to allow it to be written to.','envision') , '<strong>'. CLOUDFW_UPLOADDIR . '</strong>' )
	  )
	);
}

function cloudfw_check_cache_folder_message() {
	  printf ("<div class='cloudfw-update-messages error'>%s</div>",
	  sprintf ("<div style='padding:15px;'>%s</div>",
		sprintf ( __('Error: %s folder is not writable. Please adjust the chmod permissions to allow it to be written to.','envision') , '<strong>' . CACHE_DIR_BASE . '</strong>')
	  )
	);
}

/**
 *	Checks max_input_vars values
 */
include( dirname( __FILE__ ) . '/cloudfw.check.max_input_vars.php' );

/**
 *	Enables embed autourls
 *
 *	@since 1.0
 */
if ( ! get_option('embed_autourls') ) {
	update_option('embed_autourls',1);
}