<?php

return array(

	array(
		'type'		=> 'module',
		'title'		=> __('State','envision-core'),
		'data'		=> array(

			## Element
			array(
				'type'		=>	'select',
				'id'		=>	'toggle_state',
				'value'		=>	$that->get_value('toggle_state'),
				'main_class'=>  'input input_250',
				'ui'		=>	true,
				'source'	=>	array(
					'opened' 		=> __('Opened','envision-core'),
					'closed' 		=> __('Closed','envision-core'),
				)							
			), // #### element: 0

		)

	),

	array(
		'type'		=> 'module',
		'title'		=> __('Title','envision-core'),
		'data'		=> array(

			## Element
			array(
				'type'		=>	'text',
				'id'		=>	'toggle_title',
				'value'		=>	$that->get_value('toggle_title'),
				'class'	=>	'input input_400 bold',
			), // #### element: 0

		)

	),

	array(
		'type'		=> 'module',
		'title'		=> __('Icons','envision-core'),
		'data'		=> array(

			## Element
			array(
				'type'		=>	'select',
				'id'		=>	'toggle_icons',
				'value'		=>	$that->get_value('toggle_icons'),
				'main_class'=>  'input input_250',
				'ui'		=>	true,
				'source'	=>	array(
					'NULL'                            				                => __('Default','envision-core'),
					'fontawesome-plus/fontawesome-minus'                            => __('Plus / Minus','envision-core'),
					'fontawesome-caret-down/fontawesome-caret-up'                   => __('Caret Down / Up','envision-core'),
					'fontawesome-chevron-down/fontawesome-chevron-up'               => __('Chevron Down / Up','envision-core'),
					'fontawesome-circle-blank/fontawesome-circle'                   => __('Circles','envision-core'),
					'fontawesome-check/fontawesome-check-sign'                      => __('Check','envision-core'),
					'fontawesome-folder-close-alt/fontawesome-folder-close'         => __('Folders','envision-core'),
					'fontawesome-bookmark-empty/fontawesome-bookmark'               => __('Bookmark','envision-core'),
					'fontawesome-question/fontawesome-question-sign'                => __('Question','envision-core'),
					'fontawesome-info/fontawesome-info'                             => __('Info','envision-core'),
					'fontawesome-volume-off/fontawesome-volume-up'                  => __('Volume Off / On','envision-core'),
					'fontawesome-ellipsis-horizontal/fontawesome-ellipsis-vertical' => __('Ellipsis','envision-core'),
				)							
			), // #### element: 0

		)

	),

	array(
		'type'		=> 'module',
		'title'		=> __('Group Key','envision-core'),
		'optional'	=> true,
		'data'		=> array(

			## Element
			array(
				'type'		=>	'text',
				'id'		=>	'toggle_group',
				'value'		=>	$that->get_value('toggle_group'),
				'class'		=>	'input input_100',
			), // #### element: 0

		)

	),


	array(
		'condition'	=> !$that->is_composer,
		'type'		=> 'module',
		'title'		=> __('Title','envision-core'),
		'data'		=> array(

			## Element
			array(
				'type'		=>	'textarea',
				'id'		=>	'toggle_content',
				'value'		=>	$that->get_value('toggle_content'),
				'width'		=>	400,
				'line'		=>	5,
			), // #### element: 0

		)

	),

	array(
		'type'		=> 'module',
		'title'		=> array(__('Margin Top','envision-core'), __('Margin Bottom','envision-core')),
		'layout'	=> 'split',
		'data'		=> array(

			## Element
			array(
				'type'		=>	'text',
				'id'		=>	'margin_top',
				'value'		=>	$that->get_value('margin_top'),
				'width'		=>	70
			), // #### element: 0

			## Element
			array(
				'type'		=>	'text',
				'id'		=>	'margin_bottom',
				'value'		=>	$that->get_value('margin_bottom'),
				'width'		=>	70
			), // #### element: 0

		)

	),


	array(
		'type'		=> 'module',
		'layout'	=> 'split',
		'title'		=> array(__('Custom ID','envision-core'), __('Custom Class','envision-core')),
		'data'		=> array(

			## Element
			array(
				'type'		=>	'text',
				'id'		=>	'custom_id',
				'value'		=>	$that->get_value('custom_id'),
				'width'		=>	150,
			), // #### element: 0

			## Element
			array(
				'type'		=>	'text',
				'id'		=>	'custom_class',
				'value'		=>	$that->get_value('custom_class'),
				'width'		=>	150,
			), // #### element: 0

		)

	),

	
);