<?php
/*
 * Plugin Name: Image
 * Plugin URI: http://wptation.com
 * Description:
 * Version: 1.0
 * Author: Orkun Gürsel
 * Author URI: http://wptation.com
 * Shortcode:
 * Attributes:
 */
cloudfw_register_shortcode( 'CloudFw_Shortcode_Image', 'image', 'advanced', 20 );
if( ! class_exists('CloudFw_Shortcode_Image') ) {
	class CloudFw_Shortcode_Image extends CloudFw_Shortcodes {

		function get_called_class(){ return get_class($this); }


		/** Add the shortcode to the composer */
		function composer(){
			return array(
				'composer'		=> true,
				'ajax'			=> true,
				'icon'			=> 'image',
				'group'			=> 'composer_widgets',
				'line'			=> 160,
				'options'		=> array(
					'title'				=> __('Single Image','envision-core'),
					'column'			=> '1/1',
					'allow_columns'		=> true,
				)
			);
		}

		/** Run */
		function shortcode( $atts = array(), $content =  NULL ) {

			extract(cloudfw_make_var(array(
				'id'            => '',
				'class'         => '',
				'device'        => '',
				'border_radius' => '',
				'margin_top'    => '',
				'margin_bottom' => '',
				'margin_left'   => '',
				'margin_right'  => '',
				'floating' 		=> '',
				'src'           => NULL,
				'retina'        => NULL,
				'link'          => NULL,
				'target'        => NULL,
				'position'      => NULL,
				'radius'        => NULL,
				'style'         => NULL,
				'title'         => NULL,
				'alt'           => NULL,
				'caption'       => NULL,

				'resize'        => NULL,
				'resize_width'  => NULL,
				'resize_height' => NULL,

				'shadow'        => NULL,
				'lightbox'      => FALSE,
				'lightbox_group'=> NULL,
			), _check_onoff_false($atts)));

			if ( !$src ) {
				return '';
			}

			$image_src = $src;

			if ( !$id ) {
				$id = cloudfw_id('ui--image');
			}

			$out  = '';
			$classes = array();
			$wrap_classes = array();

			$wrap_classes[] = 'ui--image-wrap';
			$wrap_classes[] = 'clearfix';
			$wrap_classes[] = cloudfw_visible( $device );

			if ( ! empty( $floating ) ) {
				if ( $floating == 'right' ) {
					$wrap_classes[] = 'alignright';
				} elseif ( $floating == 'left' ) {
					$wrap_classes[] = 'alignleft';
				}
			}

			$classes[] = 'ui--image';
			$classes[] = $class;

			if ( $shadow ) {
				$wrap_classes[] = 'ui--animation';
			} else {
				$classes[] = 'ui--animation';
			}

			if ( ! empty( $border_radius ) ) {
				$classes[] = $border_radius;
			}

			if ( $resize && ((int) $resize_width > 0 || (int) $resize_height > 0) ) {
				$src = cloudfw_thumbnail( array( 'src' => $image_src, 'w' => (int) $resize_width, 'h' => (int) $resize_height ) );
				//$retina = cloudfw_thumbnail( array( 'src' => $image_src, 'w' => (int) $resize_width, 'h' => (int) $resize_height, 'retina' => true ) );
			}

			if ( ! cloudfw_is_retina() ) {
				$retina = '';
			}


			/** Image */
			$out = "<img ".
				cloudfw_make_id( $id ) .
				cloudfw_make_class($classes, true) .
				cloudfw_make_attribute( array(
					'src'		=> $src,
					'alt'		=> $alt ? $alt : $title,
					'title'		=> $title,
					'data-at2x'	=> !empty($retina) ? $retina : null,
					'width'     => $resize_width,
					'height'    => $resize_height,
				), FALSE ) .
				cloudfw_make_style_attribute( array(
					'style'     => $style,
				), FALSE, TRUE )

			."/>";

			/** Lightbox */
			if ( $lightbox && empty( $link ) ) {
				$link = $image_src;
			}

			/** Link */
			if ( $link ) {
				$lightbox_attr = '';

				if ( $lightbox ) {
					$lightbox_attr = empty($lightbox_group) ? 'prettyPhoto' : "prettyPhoto[{$lightbox_group}]";
				}

				$attributes = array();

				$href = cloudfw_get_page_link( $link );
				if ( ! empty( $href ) ) {
					$attributes['href'] = $href;
				}

				if ( ! empty( $target ) ) {
					$attributes['target'] = $target;
				}

				if ( ! empty( $lightbox_attr ) ) {
					$attributes['data-rel'] = $lightbox_attr;
				}

				$out = "<a" . cloudfw_make_attribute( $attributes, FALSE) .">{$out}</a>";

			}

			/** Add position class */
			if( $position ) {
				$wrap_classes[] = "text-" . $position;
				$wrap_classes[] = "ui--block";
			}

			if( ! empty( $caption ) ) {
				$out .= '<div class="ui--imag-caption flex-caption">' . $caption . '</div>';
			}

			$out = cloudfw_UI_shadow( $shadow, $out, 'ui--shadow-abs', '<div class="ui--image-inline-block">', '</div>' );

			$out = "<div" .
				cloudfw_make_class( $wrap_classes, true) .
				cloudfw_make_style_attribute( array(
					'margin-top'    => $margin_top,
					'margin-bottom' => $margin_bottom,
					'margin-left'   => $margin_left,
					'margin-right'  => $margin_right,
				), FALSE, TRUE ) .
			">{$out}</div>";

			return $out;
		}

		/** Scheme */
		function scheme() {
			return array(
				'type'		=>	'shortcode:sub',
				'id'		=>	'image',
				'ajax'		=>	true,
				'title'		=>	__('Single Image','envision-core'),
				'script'	=> array(
					'shortcode'  => 'image',
					'tag_close'  => false,
					'attributes' =>	array(
						'id'            => array( 'e' => 'custom_id' ),
						'class'         => array( 'e' => 'custom_class' ),
						'floating'      => array( 'e' => 'image_floating' ),
						'device'        => array( 'e' => 'the_device' ),
						'border_radius' => array( 'e' => 'border_radius' ),
						'margin_top'    => array( 'e' => 'margin_top' ),
						'margin_bottom' => array( 'e' => 'margin_bottom' ),
						'margin_left'   => array( 'e' => 'margin_left' ),
						'margin_right'  => array( 'e' => 'margin_right' ),

						'src'           => array( 'e' => 'image_src', 'required' => __('Please upload an image','envision-core') ),
						'retina'        => array( 'e' => 'image_retina' ),
						'link'          => array( 'e' => 'image_link' ),
						'target'        => array( 'e' => 'image_link_target' ),
						'position'      => array( 'e' => 'image_position' ),
						'style'         => array( 'e' => 'image_style' ),
						'caption'       => array( 'e' => 'image_caption' ),
						'alt'           => array( 'e' => 'image_alt' ),
						'title'         => array( 'e' => 'image_title' ),
						'resize'        => array( 'e' => 'image_auto_resize', 'onoff' => true ),
						'lightbox'      => array( 'e' => 'image_lightbox', 'onoff' => true ),
						'lightbox_group'=> array( 'e' => 'image_lightbox_group' ),
						'resize_width'  => array( 'e' => 'resize_width' ),
						'resize_height' => array( 'e' => 'resize_height' ),
						'shadow'        => array( 'e' => 'image_shadow' ),
					),
					'if'		 =>	array(
						array(
							'type'    => 'toggle',
							'e' 	  => 'image_auto_resize',
							'related' => 'imageWidgetAutoResizeOptions',
							'targets' => array(
								array('1', '#resize_width'),
							)
						)

					)

				),
				'data'		=>	array(

					array(
						'type'		=> 'module',
						'title'		=> __('Visibility','envision-core'),
						'data'		=> array(

							## Element
							array(
								'type'		=>	'select',
								'id'		=>	'the_device',
								'value'		=>	$this->get_value('the_device'),
					            'source'	=>	array(
					            	'type'		=>	'function',
					            	'function'	=>	'cloudfw_admin_get_visibility_options'
					            ),
								'width'		=>	250,
							), // #### element: 0

						)

					),

					array(
						'type'		=> 'module',
						'title'		=> __('Image','envision-core'),
						'data'		=> array(

							## Element
							array(
								'type'		=>	'upload',
								'id'		=>	'image_src',
								'value'		=>	$this->get_value('image_src'),
								'removable'	=>	true,
								'hide_input'=>	false,
								'library'	=>	true,
								'store'		=>	true,
								'to_alt'	=>	'image_title',
							), // #### element: 0

						)

					),

					array(
						'type'		=> 'module',
						'title'		=> __('Image for Retina Screens','envision-core'),
						'optional'	=>	true,
						'data'		=> array(

							## Element
							array(
								'type'		=>	'upload',
								'id'		=>	'image_retina',
								'value'		=>	$this->get_value('image_retina'),
								'removable'	=>	true,
								'hide_input'=>	false,
								'library'	=>	true,
								'store'		=>	true,
								//'desc'	=>	''

							),

						)

					),

					array(
						'type'		=>	'mini-section',
						'title'		=>	__('Resize','envision-core'),
						'data'		=> 	array(


							array(
								'type'		=> 'module',
								'title'		=> __('Auto Resize','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'onoff',
										'id'		=>	'image_auto_resize',
										'value'		=>	$this->get_value('image_auto_resize', 'FALSE'),

									), // #### element: 0

								)

							),

							array(
								'type'		=> 'module',
								'related'	=> 'imageWidgetAutoResizeOptions',
								'layout'	=> 'split',
								'title'		=> array(__('Resize Width','envision-core'), __('Resize Height','envision-core')),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'text',
										'id'		=>	'resize_width',
										'value'		=>	$this->get_value('resize_width'),
										'width'		=>	70,
										'unit'		=>	'px',
									), // #### element: 0

									## Element
									array(
										'type'		=>	'text',
										'id'		=>	'resize_height',
										'value'		=>	$this->get_value('resize_height'),
										'width'		=>	70,
										'unit'		=>	'px',
									), // #### element: 0

								)

							),


						)

					),


					array(
						'type'		=>	'mini-section',
						'title'		=>	__('Link','envision-core'),
						'data'		=>	array(


							array(
								'type'		=> 'module',
								'title'		=> __('Link','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'page-selector',
										'id'		=>	'image_link',
										'value'		=>	$this->get_value('image_link'),
									), // #### element: 0

								)

							),


							array(
								'type'		=> 'module',
								'title'		=> __('Target','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	'image_link_target',
										'value'		=>	$this->get_value('image_link_target'),
										'ui'		=>	true,
										'main_class'=>  'input input_250',
										'source'	=>	array(
				                            'NULL'      =>  '',
											'_blank'	=> __('Open in a new tab or window','envision-core'),
										)

									), // #### element: 0

								)

							),



						)

					),

					array(
						'type'		=>	'mini-section',
						'title'		=>	__('Lightbox','envision-core'),
						'data'		=>	array(

									array(
								'type'		=> 'module',
								'layout'	=> 'split',
								'title'		=> array(__('Open link in the Lightbox?','envision-core'), __('Lightbox Group Alias (optional)','envision-core')),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'onoff',
										'id'		=>	'image_lightbox',
										'value'		=>	$this->get_value('image_lightbox', 'FALSE'),

									), // #### element: 0

									## Element
									array(
										'type'		=>	'text',
										'id'		=>	'lightbox_group',
										'value'		=>	$this->get_value('lightbox_group'),
										'width'		=>	200,

									), // #### element: 0

								)

							),



						)

					),


					array(
						'type'		=>	'mini-section',
						'title'		=>	__('Style / Layout','envision-core'),
						'data'		=>	array(


							array(
								'type'		=> 'module',
								'title'		=> __('Align','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	'image_position',
										'value'		=>	$this->get_value('image_position'),
										'source'	=>	array(
											'NULL'		=>	__('Default','envision-core'),
											'left'		=>	__('Left','envision-core'),
											'center'	=>	__('Center','envision-core'),
											'right'		=>	__('Right','envision-core'),
										),
										'width'		=>	200

									), // #### element: 0

								)

							),

							array(
								'type'		=> 'module',
								'title'		=> __('Floating','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	'image_floating',
										'value'		=>	$this->get_value('image_floating'),
										'source'	=>	array(
											'NULL'		=>	__('No Floating','envision-core'),
											'left'		=>	__('Left','envision-core'),
											'right'		=>	__('Right','envision-core'),
										),
										'width'		=>	200

									), // #### element: 0

								)

							),

							array(
								'type'		=> 'module',
								'title'		=> __('Shadow','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	'image_shadow',
										'value'		=>	$this->get_value('image_shadow'),
										'source'	=>	array(
											'type'			=> 'function',
											'function'		=> 'cloudfw_admin_loop_shadows',
										),
										'width'		=>	250,

									), // #### element: 0

								)

							),

							array(
								'type'		=> 'module',
								'title'		=> __('Border Radius','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	'border_radius',
										'value'		=>	$this->get_value('border_radius'),
										'source'	=>	array(
											'NULL'			=> __('No Radius','envision-core'),
											'radius-3px'	=> __('3px Radius','envision-core'),
											'radius-6px'	=> __('6px Radius','envision-core'),
											'radius-30px'	=> __('30px Radius','envision-core'),
											'radius-circle'	=> __('Circle','envision-core'),
										),
										'width'		=>	200

									), // #### element: 0

								)

							),

							array(
								'type'		=> 'module',
								'title'		=> __('Margins','envision-core'),
								'layout'	=> 'float',
								'data'		=> array(

									## Element
									array(
										'type'		=>	'text',
										'id'		=>	'margin_top',
										'title'		=>	__('Top','envision-core'),
										'value'		=>	$this->get_value('margin_top'),
										'width'		=>	50,
										'unit'		=>	'px'
									), // #### element: 0

									## Element
									array(
										'type'		=>	'text',
										'title'		=>	__('Bottom','envision-core'),
										'id'		=>	'margin_bottom',
										'value'		=>	$this->get_value('margin_bottom'),
										'width'		=>	50,
										'unit'		=>	'px'
									), // #### element: 0

									## Element
									array(
										'type'		=>	'text',
										'title'		=>	__('Left','envision-core'),
										'id'		=>	'margin_left',
										'value'		=>	$this->get_value('margin_left'),
										'width'		=>	50,
										'unit'		=>	'px'
									), // #### element: 0

									## Element
									array(
										'type'		=>	'text',
										'title'		=>	__('Right','envision-core'),
										'id'		=>	'margin_right',
										'value'		=>	$this->get_value('margin_right'),
										'width'		=>	50,
										'unit'		=>	'px'
									), // #### element: 0

								)


							),



							array(
								'type'		=> 'module',
								'title'		=> __('Custom Style Code','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'textarea',
										'id'		=>	'image_style',
										'value'		=>	$this->get_value('image_style'),
										'width'		=>	'90%',
										'line'		=>	'2',
										'wrap'		=>	'true',

									), // #### element: 0

								)

							),

						)

					),


					array(
						'type'		=>	'mini-section',
						'title'		=>	__('Other Options','envision-core'),
						'data'		=>	array(

							array(
								'type'		=> 'module',
								'title'		=> __('Image Caption Text','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'textarea',
										'id'		=>	'image_caption',
										'value'		=>	$this->get_value('image_caption'),
										'width'		=>	'70%',
										'line'		=>	'3',
										'wrap'		=>	'true',

									), // #### element: 0

								)

							),

							array(
								'type'		=> 'module',
								'layout'	=> 'split',
								'title'		=> array(__('Custom ID','envision-core'), __('Custom Class','envision-core')),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'text',
										'id'		=>	'custom_id',
										'value'		=>	$this->get_value('custom_id'),
										'width'		=>	150,
									), // #### element: 0

									## Element
									array(
										'type'		=>	'text',
										'id'		=>	'custom_class',
										'value'		=>	$this->get_value('custom_class'),
										'width'		=>	150,
									), // #### element: 0

								)

							),


							array(
								'type'		=> 'module',
								'layout'	=> 'split',
								'title'		=> array(__('Alt Attribute','envision-core'), __('Title Attribute','envision-core')),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'text',
										'id'		=>	'image_alt',
										'value'		=>	$this->get_value('image_alt'),
										'width'		=>	200,

									), // #### element: 0

									## Element
									array(
										'type'		=>	'text',
										'id'		=>	'image_title',
										'value'		=>	$this->get_value('image_title'),
										'width'		=>	200,

									), // #### element: 0

								)

							),

						)

					),

				)


			);

		}


	}

}