<?php
/*
 * Plugin Name: Buttons
 * Plugin URI: http://wptation.com
 * Description:
 * Version: 1.0
 * Author: Orkun Gürsel
 * Author URI: http://wptation.com
 * Shortcode:
 * Attributes:
 */

cloudfw_register_shortcode( 'CloudFw_Shortcode_Buttons', 'button', 'style', 15 );
if ( ! class_exists('CloudFw_Shortcode_Buttons') ) {
	class CloudFw_Shortcode_Buttons extends CloudFw_Shortcodes {

		public $do_before = false;

		function get_called_class(){ return get_class($this); }


		/** Add the shortcode to the composer */
		function composer(){
			return array(
				'composer'      => true,
				'ajax'          => true,
				'icon'          => 'buttons',
				'group'         => 'composer_widgets',
				'line'          => 150,
				'options'       => array(
					'title'             => __('Button','envision-core'),
					'sync_title'        => 'button_title',
					'column'            => '1/1',
					'allow_columns'     => true,
				)
			);
		}

		/** Run */
		function shortcode( $atts = array(), $content =  NULL, $case = NULL ) {
			extract(shortcode_atts(array(
				'id'                => NULL,
				'link'              => NULL,
				'radius'            => NULL,
				'block'             => 'FALSE',
				'lightbox'          => 'FALSE',
				'color'             => "primary",
				'size'              => "normal",
				'target'            => NULL,
				'align'             => 'left',
				'style'             => NULL,
				'class'             => NULL,
				'rel'               => NULL,
				'icon'              => NULL,
				'icon_position'     => NULL,
				'shadow'            => NULL,
				'custom_effect'     => NULL,
				'title'             => '',
				'element'           => 'a',

				'margin_top'        => NULL,
				'margin_bottom'     => NULL,
				'margin_left'       => NULL,
				'margin_right'      => NULL,
				'attributes'        => array(),
			), _check_onoff_false($atts)));

			if( empty( $atts['lightbox'] ) || $atts['lightbox'] == 'FALSE' ) {
				$lightbox = false;
			}

			$classes = array();
			$classes[] = 'btn';
			$style = '';

			/** Detect button size */
			switch ( $size ) {
				case 'mini':
					$classes[] = 'btn-mini';
				break;
				case 'small':
					$classes[] = 'btn-small';
				break;
				case 'medium':
					$classes[] = 'btn-medium';
				break;
				case 'large':
				case 'big':
					$classes[] = 'btn-large';
				break;
				default:
					$classes[] = 'btn-normal';
				break;
			}

			if ( $block ) {
				$classes[] = 'btn-block';
			}

			if ( $icon_position )
				$classes[] = 'btn-icon-' . $icon_position;
			else
				$classes[] = 'btn-icon-left';

			if ( $class ) {
				$classes[] = $class;
			}

			/** Check Icon Attr */
			if ( !empty($atts['button_icon_source']) && $atts['button_icon_source'] != 'custom' ) $src = '';
			if ( !empty($atts['button_icon_source_hover']) && $atts['button_icon_source_hover'] != 'custom' ) $src_hover = '';

			$icon = cloudfw_make_icon( $icon, 'ui--icon btn-icon icon-normal' );

			if ( !empty($icon) ) {
				$classes[] = 'with-icon';
			}

			if ( $icon )
				$classes[] = 'button-hover';


			/** Link URL */
			if ( ! $link ) {
				$link = "#";
			} elseif( $link[0] == '/' ) {
				$link = cloudfw_home_url() . $link;
			}

			if ( strpos((string)$link, '%permalink%') !== false ) {
				global $current_link;
				if ( empty($current_link) ) {
					$current_link = get_permalink();
				}

				$link = str_replace('%permalink%', $current_link, $link);
			}

			$button_color = (array) cloudfw_make_button_style( $color );
			extract($button_color);

			if ( !empty($button_classes) ) {
				$classes[] = $button_classes;
			}

			if ( !empty($radius) ) {
				$classes[] = $radius;
			}

			if ( $is_custom_color && cloudfw_vc_get( 'css_button_border', $color ) === true  ) {
				$classes[] = 'btn-with-border';
			}

			if ( empty( $attributes ) ) {
				$attributes = array();
			}

			$wrap_classes = array();
			$wrap_attributes = array();

			if ( !empty( $id ) ) $attributes['id'] = $id;
			if ( !empty( $link ) ) $attributes['href'] = $link;
			if ( !empty( $rel ) ) $attributes['rel'] = $rel;
			if ( !empty( $style ) ) $attributes['style'] = $style;
			if ( !empty( $target ) ) $attributes['target'] = $target;
			if ( !empty( $title ) ) $attributes['title'] = $title;
			if ( !empty( $alt ) ) $attributes['alt'] = $alt;

			$margins = cloudfw_make_style_attribute( array(
				'margin-left'    => $margin_left,
				'margin-right'   => $margin_right,
				'margin-top'     => $margin_top,
				'margin-bottom'  => $margin_bottom,
			), FALSE, FALSE );

			if( $align != 'left' ) {
				$wrap_classes[] = "text-{$align}";
			}

			if ( !empty( $shadow ) ) {
				$wrap_attributes['style'] = $margins;
			} else {
				$attributes['style'] = $margins;
			}

			if ( !empty( $wrap_classes ) || !empty( $wrap_attributes ) ) {
				$wrap_classes[] = 'ui--animation';
				$wrap_attributes['data-fx'] = $custom_effect;

			} else {
				$classes[] = 'ui--animation';
				$attributes['data-fx'] = $custom_effect;
			}

			if ( $lightbox ) {
				$attributes['data-rel'] = 'prettyPhoto[]';
			}

			if ( empty( $element ) ) {
				$element = 'a';
			}

			$out = '';
			$out .= "<{$element}".
				cloudfw_make_class( $classes, true ) .
				cloudfw_make_attribute( $attributes, false ) .
			">";

			if ( $icon && $icon_position != 'right' ) {
				$out .= "<span class=\"button-icon\">{$icon}</span>";
			}

			if ( !empty($content) ) {
				$out .= "{$content}";
			} else {
				$out .= "<span class=\"button-text-placeholder\"></span>";
			}

			if ( $icon && $icon_position == 'right' ) {
				$out .= "<span class=\"button-icon\">{$icon}</span>";
			}

			$out .= "</{$element}>";
			$out .= " "; // blank space

			if ( !empty( $shadow ) ) {
				$shadow_wrap_classes = array();

				if ( $block ) {
					$shadow_wrap_classes[] = 'ui--block';
				} else {
					$shadow_wrap_classes[] = 'ui--inline-block';
				}

				$out = cloudfw_UI_shadow( $shadow, $out, 'ui--shadow-abs', '<div'. cloudfw_make_class( $shadow_wrap_classes, true ) .'>', '</div>' );
				$wrap_classes[] = 'ui--button-wrapper';
			}

			if ( !empty( $wrap_classes ) || !empty( $wrap_attributes ) ) {

				$out = "<div".
					cloudfw_make_class( $wrap_classes, true ) .
					cloudfw_make_attribute( $wrap_attributes, false ) .
				">{$out}</div>";

			}

			return $out;

		}

		/** Admin Scheme */
		function scheme() {
			return array(
				'title'     =>  __('Buttons','envision-core'),
				'script'    => array(
					'shortcode'  => 'button',
					'tag_close'  => true,
					'attributes' => array(
						'size'          => array( 'e' => 'button_size' ),
						'color'         => array( 'e' => 'button_color', 'required' => __('Please select a color for the button','envision-core') ),
						'link'          => array( 'e' => 'button_link', 'required' => __('Please insert a button link','envision-core') ),
						'target'        => array( 'e' => 'button_target' ),
						'align'         => array( 'e' => 'button_align' ),
						'radius'        => array( 'e' => 'button_radius' ),
						'block'         => array( 'e' => 'button_block', 'onoff' => true ),
						'lightbox'      => array( 'e' => 'button_lightbox', 'onoff' => true ),
						'icon_position' => array( 'e' => 'button_icon_icon_position' ),
						'icon'          => array( 'e' => 'button_icon_pre' ),
						'content'       => array( 'e' => 'button_title', 'force' => true, 'default' => __('Button Title','envision-core') ),
						'shadow'        => array( 'e' => 'button_shadow' ),
						'title'         => array( 'e' => 'button_title_attr' ),
						'id'            => array( 'e' => 'button_id_attr' ),
						'custom_effect' => array( 'e' => 'button_custom_effect' ),
						'margin_top'    => array( 'e' => 'margin_top' ),
						'margin_bottom' => array( 'e' => 'margin_bottom' ),
					)
				),
				'data'      =>  $this->load_scheme( __FILE__ )
			);

		}


		/** Skin map */
		function skin_map( $map ){
			/** Primary Buttons */

			$map  -> id      ( 'primary_button' )
				  -> selector( '.btn-primary' )
				  -> attr    ( 'color', '', true )
				  -> attr    ( 'gradient', array(), true )
				  -> pattern ( 'text-shadow',
							   '0 -1px 0 #%color% !important',
						array( 'color' => '' ) );

			$map  -> id      ( 'primary_button_hover' )
				  -> selector( '.btn-primary:hover, .btn-primary:focus, .btn-primary:active, .btn-primary.active, .btn-primary.disabled, .btn-primary[disabled]' )
				  -> sync    ( 'background-color', 'primary_button', array( 'gradient', 1 ), true ); /** [attribute] [sync_element] [sync_attribute] */

			$map  -> id      ( 'secondary_button' )
				  -> selector( '.btn-secondary' )
				  -> attr    ( 'color', '', true )
				  -> attr    ( 'border-color', '', true );

			$map  -> id      ( 'secondary_button_hover' )
				  -> selector( '.btn-secondary:hover, .btn-secondary:focus, .btn-secondary:active, .btn-secondary.active, .btn-secondary.disabled, .btn-secondary[disabled]' )
				  -> attr    ( 'color', '', true )
				  -> attr    ( 'border-color', '', true );

			$map  -> id      ( 'secondary_button_dark' )
				  -> selector( '.ui-dark .btn-secondary' )
				  -> sync    ( 'color', 'auto-ui_footer_widgetized_separator', 'background-color', true )
				  -> sync    ( 'border-color', 'auto-ui_footer_widgetized_separator', 'background-color', true )
				  -> sync    ( 'color', 'footer_widgetized_separator', 'background-color', true )
				  -> sync    ( 'border-color', 'footer_widgetized_separator', 'background-color', true )
				  -> attr    ( 'color', '', true )
				  -> attr    ( 'border-color', '', true );

			$map  -> id      ( 'secondary_button_hover_dark' )
				  -> selector( '.ui-dark .btn-secondary:hover, .ui-dark .btn-secondary:focus, .ui-dark .btn-secondary:active, .ui-dark .btn-secondary.active, .ui-dark .btn-secondary.disabled, .ui-dark .btn-secondary[disabled]' )
				  -> sync    ( 'color', 'auto-footer_widgetized_title', 'color', true )
				  -> sync    ( 'border-color', 'auto-footer_widgetized_title', 'color', true )
				  -> sync    ( 'color', 'footer_widgetized_title', 'color', true )
				  -> sync    ( 'border-color', 'footer_widgetized_title', 'color', true )
				  -> attr    ( 'color', '', true )
				  -> attr    ( 'border-color', '', true );

			return $map;
		}

		/** Skin scheme */
		function skin_scheme( $schemes, $data ){
			return cloudfw_add_skin_scheme( 'shortcode',
				$schemes,
				array(
					'type'      =>  'module-set',
					'title'     =>  __('Button Colors','envision-core'),
					'closable'  =>  true,
					'state'     =>  'closed',
					'layout'    =>  'subtab',
					'data'      =>  array(


						## SubTab Item
						array(
							'type'      =>  'tabs',
							'tab_id'    =>  'tab:button-primary',
							'tab_title' =>  __('Primary Button Color','envision-core'),
							'data'      =>  array(

								## Module Item
								array(
									'type'      =>  'module',
									'ucode'     =>  'BUTTON, PRIMARY',
									'title'     =>  __('Primary Button Color','envision-core'),
									'title'     =>  __('Background Color','envision-core'),
									'data'      =>  array(
										## Element
										array(
											'type'      =>  'gradient',
											'id'        =>  cloudfw_sanitize('primary_button','gradient'),
											'value'     =>  $data['primary_button']['gradient'],
										), // #### element: 0

									)

								),

								## Module Item
								array(
									'type'      =>  'module',
									'title'     =>  array( __('Text Color','envision-core'), __('Text Shadow Color','envision-core')),
									'layout'    =>  'split',
									'data'      =>  array(
										## Element
										array(
											'type'      =>  'color',
											'style'     =>  'horizontal',
											'id'        =>  cloudfw_sanitize('primary_button','color'),
											'value'     =>  $data['primary_button']['color'],

										),

										## Element
										array(
											'type'      =>  'color',
											'style'     =>  'horizontal',
											'id'        =>  cloudfw_sanitize('primary_button','text-shadow color'),
											'value'     =>  $data['primary_button']['text-shadow']['color'],

										),

									)

								),

							)

						),

						## SubTab Item
						array(
							'type'      =>  'tabs',
							'tab_id'    =>  'tab:button-secondary',
							'tab_title' =>  __('Secondary Button Color','envision-core'),
							'data'      =>  array(

								## Module Item
								array(
									'type'      =>  'module',
									'ucode'     =>  'BUTTON, SECONDARY',
									'title'     =>  array( __('Border Color','envision-core'), __('Text Color','envision-core')),
									'layout'    =>  'split',
									'data'      =>  array(

										array(
											'type'      =>  'color',
											'style'     =>  'horizontal',
											'id'        =>  cloudfw_sanitize('secondary_button','border-color'),
											'value'     =>  $data['secondary_button']['border-color'],
										), // #### element: 0


										## Element
										array(
											'type'      =>  'color',
											'style'     =>  'horizontal',
											'id'        =>  cloudfw_sanitize('secondary_button','color'),
											'value'     =>  $data['secondary_button']['color'],

										),

									)

								),

								## Module Item
								array(
									'type'      =>  'module',
									'ucode'     =>  'BUTTON, SECONDARY, HOVER',
									'title'     =>  array( __('Border Color Hover','envision-core'), __('Text Color Hover','envision-core')),
									'layout'    =>  'split',
									'data'      =>  array(

										array(
											'type'      =>  'color',
											'style'     =>  'horizontal',
											'id'        =>  cloudfw_sanitize('secondary_button_hover','border-color'),
											'value'     =>  $data['secondary_button_hover']['border-color'],
										), // #### element: 0


										## Element
										array(
											'type'      =>  'color',
											'style'     =>  'horizontal',
											'id'        =>  cloudfw_sanitize('secondary_button_hover','color'),
											'value'     =>  $data['secondary_button_hover']['color'],

										),

									)

								),

								## Module Item
								array(
									'type'      =>  'module',
									'ucode'     =>  'BUTTON, SECONDARY',
									'title'     =>  array( __('Border Color','envision-core') . ' ' . __('(with Dark Background)','envision-core'), __('Text Color','envision-core')  . ' ' . __('(with Dark Background)','envision-core') ),
									'layout'    =>  'split',
									'data'      =>  array(

										array(
											'type'      =>  'color',
											'style'     =>  'horizontal',
											'id'        =>  cloudfw_sanitize('secondary_button_dark','border-color'),
											'value'     =>  $data['secondary_button_dark']['border-color'],
										), // #### element: 0


										## Element
										array(
											'type'      =>  'color',
											'style'     =>  'horizontal',
											'id'        =>  cloudfw_sanitize('secondary_button_dark','color'),
											'value'     =>  $data['secondary_button_dark']['color'],

										),

									)

								),

								## Module Item
								array(
									'type'      =>  'module',
									'ucode'     =>  'BUTTON, SECONDARY, HOVER',
									'title'     =>  array( __('Border Color Hover','envision-core') . ' ' . __('(with Dark Background)','envision-core'), __('Text Color Hover','envision-core') . ' ' . __('(with Dark Background)','envision-core')),
									'layout'    =>  'split',
									'data'      =>  array(

										array(
											'type'      =>  'color',
											'style'     =>  'horizontal',
											'id'        =>  cloudfw_sanitize('secondary_button_hover_dark','border-color'),
											'value'     =>  $data['secondary_button_hover_dark']['border-color'],
										), // #### element: 0


										## Element
										array(
											'type'      =>  'color',
											'style'     =>  'horizontal',
											'id'        =>  cloudfw_sanitize('secondary_button_hover_dark','color'),
											'value'     =>  $data['secondary_button_hover_dark']['color'],

										),

									)

								),



							)

						),


					)

				),

				5 // seq

			);

		}


		/** Typo map */
		function typo_map( $map ){
			cloudfw_add_typo_setting( $map, 'button', '.btn');
			cloudfw_add_typo_setting( $map, 'button_normal', '.btn, .btn-normal', array( 'font-size' => 12 ));
			cloudfw_add_typo_setting( $map, 'button_medium', '.btn, .btn-medium', array( 'font-size' => 12 ));
			cloudfw_add_typo_setting( $map, 'button_large', '.btn.btn-large', array( 'font-size' => 16 ));
			cloudfw_add_typo_setting( $map, 'button_small', '.btn.btn-small', array( 'font-size' => 11 ));
			cloudfw_add_typo_setting( $map, 'button_mini', '.btn.btn-mini', array( 'font-size' => 10 ));

			return $map;
		}


		/** Typo Scheme */
		function typo_scheme( $scheme, $data, $number ){

			$scheme[ cloudfw_id_for_sequence( $scheme, $number ) ] = array(
				'type'          =>  'container',
				'width'         =>  940,
				'footer'        =>  false,
				'title'         =>  __('Buttons','envision-core'),
				'data'          =>  array(

					array(
						'type'      =>  'typo-set',
						'title'     =>  __('Button Text','envision-core'),
						'id'        =>  cloudfw_sanitize('button'),
						'value'     =>  $data['button'],
						'data'      =>  array(
							'line-height'     => false,
							'letter-spacing'  => false,
							'font-size'       => false,
						)

					),

					array(
						'type'      =>  'typo-set',
						'title'     =>  __('Button Text(Large Size)','envision-core'),
						'id'        =>  cloudfw_sanitize('button_large'),
						'value'     =>  $data['button_large'],
						'data'      =>  array(
							'line-height'     => false,
						)

					),

					array(
						'type'      =>  'typo-set',
						'title'     =>  __('Button Text(Normal Size)','envision-core'),
						'id'        =>  cloudfw_sanitize('button_normal'),
						'value'     =>  $data['button_normal'],
						'data'      =>  array(
							'line-height'     => false,
						)

					),

					array(
						'type'      =>  'typo-set',
						'title'     =>  __('Button Text(Medium Size)','envision-core'),
						'id'        =>  cloudfw_sanitize('button_medium'),
						'value'     =>  $data['button_medium'],
						'data'      =>  array(
							'line-height'     => false,
						)

					),

					array(
						'type'      =>  'typo-set',
						'title'     =>  __('Button Text(Small Size)','envision-core'),
						'id'        =>  cloudfw_sanitize('button_small'),
						'value'     =>  $data['button_small'],
						'data'      =>  array(
							'line-height'     => false,
						)

					),

					array(
						'type'      =>  'typo-set',
						'title'     =>  __('Button Text(Mini Size)','envision-core'),
						'id'        =>  cloudfw_sanitize('button_mini'),
						'value'     =>  $data['button_mini'],
						'data'      =>  array(
							'line-height'     => false,
						)

					),

				)


			);

			return $scheme;


		}
	}
}
