<?php
	$logout_url   = wp_logout_url();
	$current_user = wp_get_current_user();
?>

<div id="mini-user-container" class="ui--custom-login mini-user-container clearfix">
	<?php echo get_avatar( $current_user->ID, 40 ); ?>
	<div class="mini-user-content">
		<div class="mini-user-username"><?php echo sprintf( cloudfw_translate( 'custom_login.widget.logged_in.text' ) , $current_user->display_name); ?></div>
		<div class="mini-user-logout" class="ui--animation">
			<?php if ( ( $page_id = cloudfw_get_option( 'custom_login_pages', 'profile' ) ) && ( $title = get_the_title( $page_id ) ) ) { ?>
				<a class="btn btn-small btn-secondary" href="<?php echo esc_url( get_permalink( $page_id ) ); ?>"><?php echo $title; ?></a>
			<?php } ?>
			<a class="btn btn-small btn-secondary" href="<?php echo esc_url( wp_logout_url() );?>"><?php echo cloudfw_translate( 'custom_login.widget.logout.text' ); ?></a>
		</div>

	</div>

</div>